import java.awt.*;
import java.awt.event.*;
import javax.swing.*;


public class Fractal extends JFrame{
	
	Graphics g = null;
	
	private static int   windowWidth       = 800;
    private static int   windowHeight      = 700;
    private static float treeHeight        = 80.0f;
    private static float treeWidth         = 1.0f;
    private static float left_alpha        = 3.0f;
    private static float firstAngle        = 0.0f;
    private static float secondAngle       = 0.0f;
    private static float thirdAngle        = 0.0f;
    private static int   levelin           = 0;
    private static float treeWidth_factor;
    private static float treeHeight_factor;
    private static int   level; 
    private static float x, y, x1, y1;
    private static float turtle_x, turtle_y, turtle_r, turtle_theta;
    
    Label input_label;
    
    TextField input_text1;
    TextField input_text2;
    TextField input_text3;
  
//---------------------------------------------------------------------Fraktalas  
  
	Fractal(){
		
	    setTitle("Medelis");
    	setSize(windowWidth,windowHeight);
        setVisible(true);
	   	setLayout(new FlowLayout());
	   	                               
	    input_label = new Label("1 kampas: ");
        input_text1 = new TextField(3);
        input_text1.setText("10");
        add(input_label);
        add(input_text1);
                                  
        input_label = new Label("2 kampas: ");
        input_text2 = new TextField(3);
        input_text2.setText("20");
        add(input_label);
        add(input_text2);
                                   
        input_label = new Label("3 kampas: ");
        input_text3 = new TextField(3);
        input_text3.setText("350");
        add(input_label);
        add(input_text3);
              
	    Container contentPane = getContentPane();
	   	                          
	    JPanel buttonPanel = new JPanel();
	    
	    addButton(buttonPanel, "Auginti medeli",
	    new ActionListener(){
	        public void actionPerformed(ActionEvent evt){
                levelin = levelin +1;
                paint();
                
	        }
	     });

	    addButton(buttonPanel, "Iseiti",
	    new ActionListener(){
	        public void actionPerformed(ActionEvent evt){
	            System.exit(0);
	        }
	    });
	    
	    contentPane.add(buttonPanel, BorderLayout.WEST);
      
        paint();
    }
	  
	public void addButton(Container c, String title,
	    ActionListener listener){
	        JButton button = new JButton(title);
	        c.add(button);
	        button.addActionListener(listener);
	    }

//-----------------------------------------------------------------Piesti medeli	

    public void paint(){
         
        firstAngle  = Float.parseFloat(input_text1.getText());
        secondAngle = Float.parseFloat(input_text2.getText());
        thirdAngle  = Float.parseFloat(input_text3.getText());
        g = getGraphics();
  
        level = levelin;
        treeWidth_factor  = (float)Math.pow(2.0, -1/left_alpha);
	    treeHeight_factor = (float)Math.pow(2.0, -2/(3*left_alpha));
	    	    
	    x = (float)windowWidth/2.0f;     //Start point x
	    y = (float)windowHeight/10.0f;   //Start point y
	
        x1 = x; 
	    y1 = y+treeHeight; 
	    	   
	    drawbranch(g, (int)x, windowHeight-(int)y, (int)x1, windowHeight-(int)y1); //Piesiamas Kamienas
	    //turtle_r = treeHeight;                                //trumpinti medeli
	    turtle_theta = point(x, y, x1, y1);
	    turtle_x = x;
	    turtle_y = y;
	    turn(firstAngle);
	    generate(g, x1, y1, treeWidth_factor*treeWidth,
	                       treeHeight_factor*treeHeight, firstAngle, level);
	    turtle_theta = point(x, y, x1, y1);
	    turn(secondAngle);
	    generate(g, x1, y1, treeWidth_factor*treeWidth,
	                       treeHeight_factor*treeHeight, thirdAngle, level);
	    turtle_theta = point(x, y, x1, y1);                   
	    turn(thirdAngle);                   
	    generate(g, x1, y1, treeWidth_factor*treeWidth,
	                       treeHeight_factor*treeHeight, thirdAngle, level);                   
	} 

//------------------------------------------------------------------Piesti sakas

	void drawbranch(Graphics g, int x0, int y0, int x1, int y1){
	     
	     g.drawLine(x0, y0, x1, y1);
	}
  
//------------------------------------------------------------------------------  
  
    void generate(Graphics g, float x, float y, float treeWidth, float treeHeight,
                                                        float angle, int level){
  	    float x1, y1;

        turtle_x = x;
        turtle_y = y;
        turtle_r = treeHeight;
        step();
        x1 = turtle_x;
        y1 = turtle_y;
        level--;
        
        g.setColor(Color.green);
        drawbranch(g, (int)x, windowHeight-(int)y, (int)x1, windowHeight-(int)y1);
        
        if(level>0){
            turtle_theta = point(x, y, x1, y1);
            turn(firstAngle);
            generate(g, turtle_x, turtle_y, treeWidth_factor*treeWidth,
                           treeHeight_factor*treeHeight, firstAngle, level);
            turtle_theta = point(x, y, x1, y1);
            turn(secondAngle);
            generate(g, x1, y1, treeWidth_factor*treeWidth,
                          treeHeight_factor*treeHeight, secondAngle, level);
            turtle_theta = point(x, y, x1, y1);                   
	        turn(thirdAngle);                   
	        generate(g, x1, y1, treeWidth_factor*treeWidth,
	                       treeHeight_factor*treeHeight, thirdAngle, level);              

        }
    } 
    
//---------------------------------------------------------------------Pasukimas

    void turn(float angle){
        turtle_theta += angle;
    }
    
//------------------------------------------------------------------------------    

    float point(float x1, float y1, float x2, float y2){
        float theta;
        
        if((x2-x1)==0.0){
            if(y2>y1){
            	 theta= 90.0f;
            }
            else theta=270.0f;
        }
        else{
            theta=(float)Math.atan((y2-y1)/(x2-x1))*57.295779f;
        }
        if(x1>x2) theta += 180.0f;
        return theta;
     } 

//------------------------------------------------------------------------------
   
    void step(){
        turtle_x += turtle_r*Math.cos(turtle_theta*0.017453292);
        turtle_y += turtle_r*Math.sin(turtle_theta*0.017453292);
     }

//--------------------------------------------------------------------------Main

   public static void main(String args[]){
   	 	   
   	   new Fractal();
   }
} 
